package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.dao.CierreMasivoDao;
import com.ejie.ab04b.model.CierreMasivo;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * CierreMasivoServiceImpl NO generated by UDA, 27-sep-2016 13:26:09.
 * 
 * @author NO UDA
 */

@Service(value = "cierreMasivoService")
public class CierreMasivoServiceImpl implements CierreMasivoService {

	@Autowired()
	private CierreMasivoDao cierreMasivoDao;

	/**
	 * Filter method in the ComunicacionesAperturas table.
	 * 
	 *  filterCierreMasivo
	 *            CierreMasivo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<CierreMasivo>
	 *
	 * @param filterCierreMasivo the filter cierre masivo
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */

	public JQGridResponseDto<CierreMasivo> findCierreMasivo(
			CierreMasivo filterCierreMasivo, JQGridRequestDto jqGridRequestDto) {

		List<CierreMasivo> listaComunicacionApertura = this.cierreMasivoDao
				.findCierreMasivo(
						filterCierreMasivo != null ? filterCierreMasivo
								: new CierreMasivo(), jqGridRequestDto);
		Long recordNum = this.cierreMasivoDao
				.findCierreMasivoCount(filterCierreMasivo != null ? filterCierreMasivo
						: new CierreMasivo());

		return new JQGridResponseDto<CierreMasivo>(jqGridRequestDto, recordNum,
				listaComunicacionApertura);
	}

	/**
	 * Filter method in the ComunicacionesAperturas table.
	 * 
	 *  filterCierreMasivo
	 *            CierreMasivo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<CierreMasivo>
	 *
	 * @param filterCierreMasivo the filter cierre masivo
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */

	public List<CierreMasivo> findListCierreMasivo(
			CierreMasivo filterCierreMasivo, JQGridRequestDto jqGridRequestDto) {

		return this.cierreMasivoDao.findCierreMasivo(filterCierreMasivo,
				jqGridRequestDto);
	}
}
